import uuid
import copy
from envs import applications

class Task(object):
    def __init__(self, app_type, data_size, client_index = None, server_index = None, arrival_timestamp=None):
        self.client_index = client_index 
        self.server_index = server_index 
        self.app_type = app_type
        self.data_size = data_size
        self.is_start = False
        self.computation_over = 0
        self.uuid = uuid.uuid4()
        self.received_data_size = 0
        self.parent_uuid = None
        self.child_uuid = None
        self.arrival_timestamp = arrival_timestamp
        self.start_timestamp = None 
        self.end_timestamp = None 

    def get_uuid(self):
        return self.uuid.hex

    def make_child_task(self, offload_data_bits):
        new_task = copy.deepcopy(self)
        new_task.uuid = uuid.uuid4()
        new_task.parent_uuid = self.get_uuid()
        self.child_uuid = new_task.get_uuid()
        new_task.data_size = offload_data_bits
        self.data_size = self.data_size-offload_data_bits
        return new_task

    def get_workload(self):
        return applications.app_info[self.app_type]['workload']

    def get_app_type(self):
        return self.app_type

    def get_data_size(self):
        return self.data_size

    def set_arrival_time(self, arrival_timestamp):
        self.arrival_timestamp = arrival_timestamp

    def get_arrival_time(self):
        return self.arrival_timestamp

    def is_client_index(self):
        return bool(self.client_index)

    def is_server_index(self):
        return bool(self.server_index)

    def offload_state(self):
        if self.is_client_index() and self.is_server_index():
            return 3
        elif self.is_client_index() and (not self.is_server_index()):
            return 2
        elif (not self.is_client_index()) and self.is_server_index():
            return 1
        else :
            return 0
